#!/bin/sh 



script_dir=$(dirname $0)
script_dir=$(cd $script_dir;pwd)
script_name=$(basename $0)

usage(){
       echo Usage:$script_name <--ofed-dir OFED_DIR> --verify [custom_name] [custom_name] ...
}


CUSTOM_LIST=
PATCH_LIST_KERNEL=
PATCH_LIST_USER=
verify=0

while [[ ! -z "$1" ]] ; do
        case $1 in
                --ofed-dir)
			OFED_DIR=$2;
                        shift
                        shift
                ;;
                --verify)
			verify=1
			shift
		;;
                -h|--help|--*)
			usage
                        exit
                ;;
		*)
			if [ ! -d $script_dir/$1 ] ; then
				echo "ERROR: custom $1 not found"
				exit 1
			fi
			CUSTOM_LIST="$CUSTOM_LIST $1"
			shift
		;;
        esac
done

if [ ! -d $OFED_DIR ] ; then
	echo ERROR: $OFED_DIR is not a directory
	exit 1
fi

# Make Absolute path 
OFED_DIR=$(cd $OFED_DIR;pwd)

if [ ! -f $OFED_DIR/ofa_version ] ; then
	echo ERROR: File ofa_version not found
	exit 1
fi


. $OFED_DIR/ofa_version

cd $OFED_DIR
pushd SOURCES

ofa_kernel_tar=$(ls ofa_kernel*.tgz)
if [  -z $ofa_kernel_tar ] ; then
	echo "ERROR:  ofa_kernel tarball not found."
	exit 1
fi
ofa_user_tar=$(ls ofa_user*.tgz)
if [  -z $ofa_user_tar ] ; then
	echo "ERROR: ofa_user tarball not found."
	exit 1
fi
ofa_kernel_dir=$(tar ztf $ofa_kernel_tar|head -1)
ofa_user_dir=$(tar ztf $ofa_user_tar|head -1)
if [ -f $ofa_kernel_tar.orig ] ; then
	cp $ofa_kernel_tar.orig     $ofa_kernel_tar
else
	cp $ofa_kernel_tar $ofa_kernel_tar.orig
fi
if [ -f $ofa_user_tar.orig ] ; then
	cp $ofa_user_tar.orig     $ofa_user_tar
else
	cp $ofa_user_tar $ofa_user_tar.orig
fi
echo unpacking $ofa_kernel_tar $ofa_user_tar
tar zxvf $ofa_kernel_tar > /dev/null  2>&1
tar zxvf $ofa_user_tar > /dev/null  2>&1
popd

mkdir -p backup
echo Refresh previous installation
files_to_restore=$(find backup -type f)
for file in $files_to_restore ; do
	orig_file=$(echo $file|cut -f2- -d/)
	echo Refreshing $orig_file
	cp $file $orig_file
done
for PatchDir in ${CUSTOM_LIST} ; do 
	echo Applying OFED framework patches for custom $PatchDir
	num_patches=$(ls $script_dir/$PatchDir/ofed_fixes/* |wc -w)
	if [ $num_patches -ne 0 ] ; then
		echo $num_patches patches found under $script_dir/$PatchDir/ofed_fixes/
		for diff_file in `ls $script_dir/$PatchDir/ofed_fixes/*`; do
			files_in_patch=$(grep ^+++ $diff_file |tr [:blank:] :|cut -f2 -d:)
			for file in $files_in_patch ; do
				file_to_patch=$(echo $file|cut -f2- -d/)
				if [ ! -f backup/$file_to_patch ] ; then
					mkdir -p backup/$(dirname $file_to_patch)
					cp $file_to_patch backup/$(dirname $file_to_patch)
				fi
			done
			patch -p1 < $diff_file 
			if [ $? -ne 0 ] ; then
				echo error: Apply of $diff_file Failed 
				exit 1 
			fi
		done
	else
		echo no patches under $script_dir/$PatchDir/ofed_fixes
	fi
done 
pushd SOURCES
for PatchDir in ${CUSTOM_LIST} ; do 
	echo copying kernel fixes for custom $PatchDir
	num_patches=$(ls $script_dir/$PatchDir/fixes/kernel/|wc -w)
	if [ $num_patches -ne 0 ] ; then
		echo $num_patches patches found under $script_dir/$PatchDir/fixes/kernel
		cp $script_dir/$PatchDir/fixes/kernel/* $ofa_kernel_dir/kernel_patches/fixes/
		for p in $script_dir/$PatchDir/fixes/kernel/* ; do
			p=$(basename $p)
			PATCH_LIST_KERNEL="$PATCH_LIST_KERNEL $p"
		done
	else
		echo no patches under $script_dir/$PatchDir/fixes/kernel
	fi
	
	echo copying kernel backports for custom $PatchDir
	for bp in $(ls $script_dir/$PatchDir/fixes/backport/)  ; do
		num_patches=$(ls $script_dir/$PatchDir/fixes/backport/$bp/|wc -w)
		if [ $num_patches -ne 0 ] ; then
			echo $num_patches patches found under $script_dir/$PatchDir/fixes/backport/$bp
			mkdir -p $ofa_kernel_dir/kernel_patches/backport/$bp
			cp $script_dir/$PatchDir/fixes/backport/$bp/* $ofa_kernel_dir/kernel_patches/backport/$bp/
			for p in $script_dir/$PatchDir/fixes/backport/$bp/* ; do
				p=$(basename $p)
				PATCH_LIST_KERNEL="$PATCH_LIST_KERNEL $p"
			done
		else
			echo no patches under $script_dir/$PatchDir/fixes/backport/$bp
		fi
	done

	echo copying kernel addons for custom $PatchDir
	if [ -d $script_dir/$PatchDir/fixes/addons ] ; then
		pushd $script_dir/$PatchDir/fixes/addons > /dev/null
		addons=$(find -type f|grep -v .svn)
		popd > /dev/null
		for ao in $addons ; do
			ao_dir=$(dirname $ao)
			mkdir -p $ofa_kernel_dir/kernel_addons/$ao_dir
			cp $script_dir/$PatchDir/fixes/addons/$ao $ofa_kernel_dir/kernel_addons/$ao_dir
		done
	fi

	echo copying user patches for custom $PatchDir
	num_patches=$(ls $script_dir/$PatchDir/fixes/user/|wc -w)
	if [ $num_patches -ne 0 ] ; then
		echo $num_patches patches found under $script_dir/$PatchDir/fixes/user
		cp $script_dir/$PatchDir/fixes/user/* $ofa_user_dir/user_patches/fixes/
		for p in $script_dir/$PatchDir/fixes/user/* ; do
			p=$(basename $p)
			PATCH_LIST_USER="$PATCH_LIST_USER $p"
		done
	else
		echo no patches under $script_dir/$PatchDir/fixes/user
	fi

done   # end for PatchDir in ${CUSTOM_LIST}

echo re-packing $ofa_kernel_tar
tar zcvf $ofa_kernel_tar $ofa_kernel_dir > /dev/null  2>&1
if [ $verify -ne 0 ] ; then
	cd $ofa_kernel_dir
	./configure > /dev/null
	if [ $? -ne 0 ] ; then
		echo ERROR: Verification failed for OFA kernel
		exit 1
	else
		echo Verification succeeded for OFA kernel
	fi
	cd -
fi
	
rm -rf $ofa_kernel_dir
echo re-packing $ofa_user_tar
tar zcvf $ofa_user_tar $ofa_user_dir > /dev/null  2>&1
if [ $verify -ne 0 ] ; then
	cd $ofa_user_dir
	./configure > /dev/null
	if [ $? -ne 0 ] ; then
		echo ERROR: Verification failed for OFA user
		exit 1
	else
		echo Verification succeeded for OFA user
	fi
	cd -
fi
rm -rf $ofa_user_dir


# Re-Generate ofa_kernel src RPM
tar zxf $ofa_kernel_tar ofa_kernel-1.2${OFA_SUBVERSION}/ofed_scripts/ofa_kernel.spec
if [ $? -ne 0 ] ; then
	echo ERROR: cant extract spec file from $ofa_kernel_tar
	exit 1
fi
sed -e {s/@VERSION@/$OFA_KERNEL_VERSION/g} ofa_kernel-1.2${OFA_SUBVERSION}/ofed_scripts/ofa_kernel.spec > /tmp/ofa_kernel.spec
mv /tmp/ofa_kernel.spec ofa_kernel-1.2${OFA_SUBVERSION}/ofed_scripts/ofa_kernel.spec
sed -e {s/@RELEASE@/$OFA_KERNEL_RELEASE/g} ofa_kernel-1.2${OFA_SUBVERSION}/ofed_scripts/ofa_kernel.spec > /tmp/ofa_kernel.spec
mv /tmp/ofa_kernel.spec ofa_kernel-1.2${OFA_SUBVERSION}/ofed_scripts/ofa_kernel.spec

chown root:root ofa_kernel-1.2${OFA_SUBVERSION}/ofed_scripts/ofa_kernel.spec
chown root:root $ofa_kernel_tar
rpmbuild -bs --define "_version $OFA_KERNEL_VERSION" --define "_release $OFA_KERNEL_RELEASE" --define "_topdir $OFED_DIR/" ofa_kernel-1.2${OFA_SUBVERSION}/ofed_scripts/ofa_kernel.spec
# Re-Generate ofa_user src RPM
tar zxf $ofa_user_tar ofa_user-1.2${OFA_SUBVERSION}/ofed_scripts/ofa_user.spec
if [ $? -ne 0 ] ; then
	echo ERROR: cant extract spec file from $ofa_user_tar
	exit 1
fi
sed -e {s/@VERSION@/$OFA_USER_VERSION/g} ofa_user-1.2${OFA_SUBVERSION}/ofed_scripts/ofa_user.spec > /tmp/ofa_user.spec
mv /tmp/ofa_user.spec ofa_user-1.2${OFA_SUBVERSION}/ofed_scripts/ofa_user.spec
sed -e {s/@RELEASE@/$OFA_USER_RELEASE/g} ofa_user-1.2${OFA_SUBVERSION}/ofed_scripts/ofa_user.spec > /tmp/ofa_user.spec
mv /tmp/ofa_user.spec ofa_user-1.2${OFA_SUBVERSION}/ofed_scripts/ofa_user.spec
chown root:root ofa_user-1.2${OFA_SUBVERSION}/ofed_scripts/ofa_user.spec
chown root:root $ofa_user_tar
rpmbuild -bs --define "_version $OFA_USER_VERSION" --define "_release $OFA_USER_RELEASE" --define "_topdir $OFED_DIR/" ofa_user-1.2${OFA_SUBVERSION}/ofed_scripts/ofa_user.spec
popd
# Update BUILD_ID 
echo Update ofed-docs
ofed_docs_rpm=$(ls SRPMS/ofed-docs-*.src.rpm)
if [ -f $ofed_docs_rpm.orig ] ; then
	cp $ofed_docs_rpm.orig $ofed_docs_rpm
else
	cp $ofed_docs_rpm $ofed_docs_rpm.orig
fi
if [ -z $ofed_docs_rpm ] ; then
	echo ERROR: RPM ofed-docs not found
	exit
fi
rpm2cpio $ofed_docs_rpm |cpio -i
rm -f $ofed_docs_rpm
ofed_docs_tar=$(ls ofed-docs-*.tar.gz)
ofed_docs_dir=$(tar ztf $ofed_docs_tar|head -1)
tar zxf $ofed_docs_tar > /dev/null
rm -f $ofed_docs_tar
echo VLT_PATCH_KER=$PATCH_LIST_KERNEL >> $ofed_docs_dir/BUILD_ID
echo VLT_PATCH_USR=$PATCH_LIST_USER >> $ofed_docs_dir/BUILD_ID
tar zcvf $ofed_docs_tar $ofed_docs_dir
mv $ofed_docs_tar SOURCES/
rpmbuild -bs --define "_topdir $OFED_DIR/" ofed-docs.spec
rm -rf $ofed_docs_dir ofed-docs.spec

exit 0

